<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

interface InterfacePostGetter
{
    public function getId(): string;

    public function getOwnerUserId(): string;

    public function getDisplayCaption(): string;

    public function getDisplayLocation(): string;

    public function getDisplayContent(): PostDisplayContentDTO;

    public function getMetaHashtags(): PostMetaHashtagsDTO;

    public function getCacheLikesCount(): string;

    public function getCacheCommentsCount(): string;

    public function getStampRegistration(): string;

    public function getStampLastUpdate(): string;
}
